@include('front.inc.header')

<section class="inner_banner_wrapper">
    <div class="container">
        <div class="inner_banner_text">
            <h5 class="sub_heading">Quartz Flooring</h5>
            <h2 class="heading">Quartz System — Extreme Durability & Slip Resistance</h2>
        </div>
    </div>
</section>

<section class="service_detail_wrapper">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6">
                <div class="service_detail_img quartz_img">
                    <img src="{{ asset('assets/front/images/quartz_img.jpeg') }}" alt="Quartz Flooring" class="img-fluid">
                </div>
            </div>
            <div class="col-lg-6">
                <div class="service_detail_text">
                    <p class="section_subtitle">HIGH PERFORMANCE</p>
                    <h3 class="section_title">Our Quartz Flooring System</h3>
                    <p class="section_desc">
                        Our Quartz System is engineered for extreme durability and slip resistance in the most demanding
                        environments. Using a combination of high-performance polyaspartic resins and decorative quartz
                        sand, this system creates a textured, multi-colored surface that is as tough as it is beautiful.
                    </p>
                    <p class="section_desc">
                        Ideal for commercial kitchens, locker rooms, pool decks, and industrial facilities, the Quartz
                        System offers superior impact resistance and remains non-slip even when wet. It's a heavy-duty
                        solution that maintains its integrity under constant foot traffic and harsh cleaning chemicals.
                    </p>
                    <div class="service_btn_box">
                        <a href="{{ url('/pricing') }}" class="common_btn">View Pricing</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="specifications_wrapper">
    <div class="container">
        <div class="spec_main_box">
            <div class="feature_icon_box_m">
                <div class="row g-4 text-center">
                    <div class="col-6 col-md-3">
                        <div class="feature_icon_box">
                            <div class="icon_circle">
                                <i class="fas fa-shoe-prints"></i>
                            </div>
                            <h5>Slip Resistant</h5>
                        </div>
                    </div>
                    <div class="col-6 col-md-3">
                        <div class="feature_icon_box">
                            <div class="icon_circle">
                                <i class="fas fa-dumbbell"></i>
                            </div>
                            <h5>Extreme Durability</h5>
                        </div>
                    </div>
                    <div class="col-6 col-md-3">
                        <div class="feature_icon_box">
                            <div class="icon_circle">
                                <i class="fas fa-shield-alt"></i>
                            </div>
                            <h5>Impact Resistant</h5>
                        </div>
                    </div>
                    <div class="col-6 col-md-3">
                        <div class="feature_icon_box">
                            <div class="icon_circle">
                                <i class="fas fa-temperature-high"></i>
                            </div>
                            <h5>Heat Resistant</h5>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-6">
                    <div class="spec_list">
                        <ul>
                            <li><i class="fas fa-check-circle"></i> Multi-Layer Protection</li>
                            <li><i class="fas fa-check-circle"></i> Decorative Quartz Sand</li>
                            <li><i class="fas fa-check-circle"></i> Non-Porous Surface</li>
                            <li><i class="fas fa-check-circle"></i> Seamless Installation</li>
                        </ul>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="spec_info_box">
                        <div class="info_item">
                            <span class="label">Installation Time:</span>
                            <span class="value">2-3 Day Installation</span>
                        </div>
                        <div class="info_item">
                            <span class="label">Safety Rating:</span>
                            <span class="value">High Slip Resistance Rating</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

@include('front.inc.footer')