@include('front.inc.header')

<section class="inner_banner_wrapper">
    <div class="container">
        <div class="inner_banner_text">
            <h5 class="sub_heading">cOMPETITIVE</h5>
            <h2 class="heading">Pricing</h2>
        </div>
    </div>
</section>

<section class="pricing_intro_wrapper section_padding">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-12">
                <div class="pricing_intro_text text-center">
                    <h3 class="section_title">How Much Will a Techshield Floor Cost?</h3>
                    <p class="section_desc">
                        We know updating your garage or workspace is an investment — and like any smart homeowner or
                        business owner, you want lasting quality without overspending.<br> At Techshield Epoxy Floors,
                        we
                        get it. When you choose Techshield, you’re choosing style, strength, and long-term savings.
                    </p>
                    <p class="section_desc">
                        Our industrial-grade epoxy and polyaspartic systems deliver premium durability, UV stability,
                        and easy maintenance, helping you save money over time by resisting wear, fading, and costly
                        repairs. <br> Each floor is customized to your space, design goals, and performance needs —
                        whether
                        it’s a sleek garage, a polished commercial floor, or a decorative flake system. Engineered to
                        last. <br> Priced with honesty. Installed with precision.
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="specifications_wrapper section_padding bg_light">
    <div class="container">
        <div class="row">
            <div class="col-lg-12 text-center mb-5">
                <p class="section_subtitle">Factors</p>
                <h3 class="section_title">Factors that Influence Price</h3>
                <p class="section_desc">There are many variables that go into the total cost of coating your concrete
                    coatings. The variations in cost depend on factors such as:</p>
            </div>
        </div>
        <div class="spec_main_box mt-0">
            <div class="feature_icon_box_m">
                <div class="row g-4 text-center">
                    <div class="col-6 col-md-3">
                        <div class="feature_icon_box">
                            <div class="icon_circle">
                                <i class="fas fa-clipboard-check"></i>
                            </div>
                            <h5>Condition of the Floor</h5>
                        </div>
                    </div>
                    <div class="col-6 col-md-3">
                        <div class="feature_icon_box">
                            <div class="icon_circle">
                                <i class="fas fa-vector-square"></i>
                            </div>
                            <h5>Square Footage</h5>
                        </div>
                    </div>
                    <div class="col-6 col-md-3">
                        <div class="feature_icon_box">
                            <div class="icon_circle">
                                <i class="fas fa-hammer"></i>
                            </div>
                            <h5>Cracked Concrete</h5>
                        </div>
                    </div>
                    <div class="col-6 col-md-3">
                        <div class="feature_icon_box">
                            <div class="icon_circle">
                                <i class="fas fa-tint-slash"></i>
                            </div>
                            <h5>Dirty & Oily Surfaces</h5>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row mt-4">
                <div class="col-12 text-center">
                    <p class="section_desc">
                        If extensive surface leveling is needed, or if the surface is dirty, oily, or heavily cracked,
                        additional preparation steps may be required to ensure the best possible finish.
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="pricing-section">
    <div class="container">
        <div class="row">
            <div class="col-12 text-center mb-5">
                <h2 class="pricing-title">CLEAR PRICING FOR PREMIUM<br>EPOXY SERVICES</h2>
            </div>
        </div>

        <div class="pricing_slider swiper">
            <div class="swiper-wrapper">
                <!-- Card 1: Solid Color -->
                <div class="swiper-slide">
                    <div class="pricing-card">
                        <span class="pricing-badge badge-best">BEST</span>
                        <div class="pricing-header">
                            <div class="price-tag">
                                <span class="currency">$3</span>
                                <span class="sq-text">SQ/FEET SQ/FT</span>
                            </div>
                            <h3 class="pricing-card-title">SOLID COLOR</h3>
                            <p class="pricing-subtitle">VARIETY OF COLORS</p>
                        </div>
                        <div class="pricing-features">
                            <ul>
                                <li><i class="fas fa-check"></i> Diamond Grinding/Shot Blast Surface Preparation</li>
                                <li><i class="fas fa-check"></i> Moisture Vapor Barrier/100% Solids Industrial Grade
                                    Base
                                    Coat</li>
                                <li><i class="fas fa-check"></i> Full Broadcast Of Decorative Flakes</li>
                                <li><i class="fas fa-check"></i> Premium High Gloss Polyaspartic Top Coat</li>
                            </ul>
                        </div>
                        <div class="pricing-footer">
                            <button class="btn_black btn-learn-more">LEARN MORE</button>
                        </div>
                    </div>
                </div>

                <!-- Card 2: Full Flakes -->
                <div class="swiper-slide">
                    <div class="pricing-card">
                        <span class="pricing-badge badge-better">BETTER</span>
                        <div class="pricing-header">
                            <div class="price-tag">
                                <span class="currency">$4</span>
                                <span class="sq-text">SQ/FEET SQ/FT</span>
                            </div>
                            <h3 class="pricing-card-title">FULL FLAKES</h3>
                            <p class="pricing-subtitle">VARIETY OF COLORS</p>
                        </div>
                        <div class="pricing-features">
                            <ul>
                                <li><i class="fas fa-check"></i> Diamond Grinding/Shot Blast Surface Preparation</li>
                                <li><i class="fas fa-check"></i> Moisture Vapor Barrier/100% Solids Industrial Grade
                                    Base
                                    Coat</li>
                                <li><i class="fas fa-check"></i> Full Broadcast Of Decorative Flakes</li>
                                <li><i class="fas fa-check"></i> Premium High Gloss Polyaspartic Top Coat</li>
                            </ul>
                        </div>
                        <div class="pricing-footer">
                            <button class="btn_black btn-learn-more">LEARN MORE</button>
                        </div>
                    </div>
                </div>

                <!-- Card 3: Quartz -->
                <div class="swiper-slide">
                    <div class="pricing-card">
                        <span class="pricing-badge badge-best">BEST</span>
                        <div class="pricing-header">
                            <div class="price-tag">
                                <span class="currency">$6</span>
                                <span class="sq-text">SQ/FEET SQ/FT</span>
                            </div>
                            <h3 class="pricing-card-title">QUARTZ</h3>
                            <p class="pricing-subtitle">VARIETY OF COLORS</p>
                        </div>
                        <div class="pricing-features">
                            <ul>
                                <li><i class="fas fa-check"></i> Diamond Grinding/Shot Blast Surface Preparation</li>
                                <li><i class="fas fa-check"></i> Primer/Sealer</li>
                                <li><i class="fas fa-check"></i> Moisture Vapor Barrier/100% Solids Industrial Grade
                                    Base
                                    Coat</li>
                                <li><i class="fas fa-check"></i> Full Broadcast Of Quartz</li>
                                <li><i class="fas fa-check"></i> Premium High Gloss Polyaspartic Top Coat</li>
                            </ul>
                        </div>
                        <div class="pricing-footer">
                            <button class="btn_black btn-learn-more">LEARN MORE</button>
                        </div>
                    </div>
                </div>

                <!-- Card 4: Metallic -->
                <div class="swiper-slide">
                    <div class="pricing-card">
                        <span class="pricing-badge badge-premium">PREMIUM</span>
                        <div class="pricing-header">
                            <div class="price-tag">
                                <span class="currency">$8</span>
                                <span class="sq-text">SQ/FEET SQ/FT</span>
                            </div>
                            <h3 class="pricing-card-title">METALLIC</h3>
                            <p class="pricing-subtitle">VARIETY OF COLORS</p>
                        </div>
                        <div class="pricing-features">
                            <ul>
                                <li><i class="fas fa-check"></i> Diamond Grinding/Shot Blast Surface Preparation</li>
                                <li><i class="fas fa-check"></i> Moisture Vapor Barrier/100% Solids Industrial Grade
                                    Base
                                    Coat</li>
                                <li><i class="fas fa-check"></i> Premium High Gloss Polyaspartic Top Coat</li>
                                <li><i class="fas fa-check"></i> Metallic Color Designer Coat</li>
                            </ul>
                        </div>
                        <div class="pricing-footer">
                            <button class="btn_black btn-learn-more">LEARN MORE</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="pricing-pagination swiper-pagination"></div>
        </div>
    </div>
</section>

<section class="gallery-section">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="gallery-content">
                    <p class="gallery-subtitle">OUR RECENT GALLERY</p>
                    <h2 class="gallery-title">SHOWCASE OF OUR<br>FLOORING SOLUTIONS</h2>
                </div>
            </div>
        </div>
    </div>

    <div class="gallery-slider-wrapper">
        <!-- Swiper -->
        <div class="swiper gallery-swiper">
            <div class="swiper-wrapper">
                <!-- Gallery Image 1 -->
                <div class="swiper-slide">
                    <div class="gallery-image">
                        <img src="{{ asset('assets/front/images/gallery3.png') }}" alt="Residential Epoxy Floor">
                    </div>
                </div>

                <!-- Gallery Image 2 -->
                <div class="swiper-slide">
                    <div class="gallery-image">
                        <img src="{{ asset('assets/front/images/gallery1.png') }}" alt="Metallic Epoxy Floor">
                    </div>
                </div>

                <!-- Gallery Image 3 -->
                <div class="swiper-slide">
                    <div class="gallery-image">
                        <img src="{{ asset('assets/front/images/gallery2.png') }}" alt="Commercial Epoxy Floor">
                    </div>
                </div>

                <!-- Gallery Image 1 -->
                <div class="swiper-slide">
                    <div class="gallery-image">
                        <img src="{{ asset('assets/front/images/gallery3.png') }}" alt="Residential Epoxy Floor">
                    </div>
                </div>

                <!-- Gallery Image 2 -->
                <div class="swiper-slide">
                    <div class="gallery-image">
                        <img src="{{ asset('assets/front/images/gallery1.png') }}" alt="Metallic Epoxy Floor">
                    </div>
                </div>

                <!-- Gallery Image 3 -->
                <div class="swiper-slide">
                    <div class="gallery-image">
                        <img src="{{ asset('assets/front/images/gallery2.png') }}" alt="Commercial Epoxy Floor">
                    </div>
                </div>
            </div>
        </div>

        <!-- Navigation Buttons -->
        <div class="gallery-navigation">
            <button class="gallery-btn-prev">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M15 18L9 12L15 6" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                        stroke-linejoin="round" />
                </svg>
            </button>
            <button class="gallery-btn-next">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M9 18L15 12L9 6" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                        stroke-linejoin="round" />
                </svg>
            </button>
        </div>
    </div>
</section>

@include('front.inc.footer')