@include('front.inc.header')

<section class="inner_banner_wrapper">
    <div class="container">
        <div class="inner_banner_text">
            <h5 class="sub_heading">Metallic Flooring</h5>
            <h2 class="heading">Metallic Coating System</h2>
        </div>
    </div>
</section>

<section class="service_detail_wrapper">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6">
                <div class="service_detail_img">
                    <img src="{{ asset('assets/front/images/sec_img1.png') }}" alt="Metallic Flooring" class="img-fluid">
                </div>
            </div>
            <div class="col-lg-6">
                <div class="service_detail_text">
                    <p class="section_subtitle">PREMIUM COATING</p>
                    <h3 class="section_title">Our Metallic Epoxy System</h3>
                    <p class="section_desc">
                        Our Metallic Epoxy System offers a sleek, one-of-a-kind look that transforms ordinary concrete
                        into a work of art. With deep color movement and reflective metallic pigments, each floor is
                        completely unique—perfect for retail spaces, offices, showrooms, and modern homes seeking a
                        high-end appearance.
                    </p>
                    <p class="section_desc">
                        This multi-layer coating system is designed for both style and performance, providing excellent
                        durability, chemical resistance, and a seamless, glossy finish. The result is a stunning,
                        mirror-like surface that’s as strong as it is sophisticated.
                    </p>
                    <div class="service_btn_box">
                        <a href="{{ url('/pricing') }}" class="common_btn">View Pricing</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="specifications_wrapper">
    <div class="container">
        <div class="spec_main_box">
            <div class="feature_icon_box_m">
                <div class="row g-4 text-center">
                    <div class="col-6 col-md-3">
                        <div class="feature_icon_box">
                            <div class="icon_circle">
                                <i class="fas fa-shield-alt"></i>
                            </div>
                            <h5>Chip Resistant</h5>
                        </div>
                    </div>
                    <div class="col-6 col-md-3">
                        <div class="feature_icon_box">
                            <div class="icon_circle">
                                <i class="fas fa-vial"></i>
                            </div>
                            <h5>Chemical Resistance</h5>
                        </div>
                    </div>
                    <div class="col-6 col-md-3">
                        <div class="feature_icon_box">
                            <div class="icon_circle">
                                <i class="fas fa-gem"></i>
                            </div>
                            <h5>Scratch Resistance</h5>
                        </div>
                    </div>
                    <div class="col-6 col-md-3">
                        <div class="feature_icon_box">
                            <div class="icon_circle">
                                <i class="fas fa-sun"></i>
                            </div>
                            <h5>UV Resistance</h5>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-6">
                    <div class="spec_list">
                        <ul>
                            <li><i class="fas fa-check-circle"></i> Mold and Bacteria Proof</li>
                            <li><i class="fas fa-check-circle"></i> Scratch Resistant</li>
                            <li><i class="fas fa-check-circle"></i> Chemical Resistant</li>
                            <li><i class="fas fa-check-circle"></i> Colors Of Choice</li>
                        </ul>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="spec_info_box">
                        <div class="info_item">
                            <span class="label">Installation Time:</span>
                            <span class="value">2-3 Day Installation</span>
                        </div>
                        <div class="info_item">
                            <span class="label">Dry Times:</span>
                            <span class="value">24 Hour Foot Traffic, 3 Day Drive On</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="gallery-section">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="gallery-content">
                    <p class="gallery-subtitle">OUR RECENT GALLERY</p>
                    <h2 class="gallery-title">SHOWCASE OF OUR<br>METALLIC FLOORING</h2>
                </div>
            </div>
        </div>
    </div>

    <div class="gallery-slider-wrapper">
        <!-- Swiper -->
        <div class="swiper gallery-swiper">
            <div class="swiper-wrapper">
                <!-- Gallery Image 1 -->
                <div class="swiper-slide">
                    <div class="gallery-image">
                        <img src="{{ asset('assets/front/images/gallery3.png') }}" alt="Residential Epoxy Floor">
                    </div>
                </div>

                <!-- Gallery Image 2 -->
                <div class="swiper-slide">
                    <div class="gallery-image">
                        <img src="{{ asset('assets/front/images/gallery1.png') }}" alt="Metallic Epoxy Floor">
                    </div>
                </div>

                <!-- Gallery Image 3 -->
                <div class="swiper-slide">
                    <div class="gallery-image">
                        <img src="{{ asset('assets/front/images/gallery2.png') }}" alt="Commercial Epoxy Floor">
                    </div>
                </div>

                <!-- Duplicate for loop -->
                <div class="swiper-slide">
                    <div class="gallery-image">
                        <img src="{{ asset('assets/front/images/about-metallic.jpg') }}" alt="Metallic Detail">
                    </div>
                </div>

                <div class="swiper-slide">
                    <div class="gallery-image">
                        <img src="{{ asset('assets/front/images/gallery1.png') }}" alt="Metallic Finish">
                    </div>
                </div>
            </div>
        </div>

        <!-- Navigation Buttons -->
        <div class="gallery-navigation">
            <button class="gallery-btn-prev">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M15 18L9 12L15 6" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                        stroke-linejoin="round" />
                </svg>
            </button>
            <button class="gallery-btn-next">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M9 18L15 12L9 6" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                        stroke-linejoin="round" />
                </svg>
            </button>
        </div>
    </div>
</section>

@include('front.inc.footer')