@include('front.inc.header')

<section class="index_banner_wrapper">
    <div class="index_banner_vid">
        @if($settings && $settings->banner_video)
            <video src="{{ asset('storage/' . $settings->banner_video) }}" loop autoplay muted playsInline></video>
        @else
            <video src="{{ asset('assets/front/images/banner_vid.mp4') }}" loop autoplay muted playsInline></video>
        @endif
    </div>
    <div class="container">
        <div class="row align-items-center justify-content-between">
            <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                <div class="index_banner_text">
                    <h5 class="sub_heading">{{ $settings->banner_subtitle ?? 'TechShield Epoxy Floors - Premium Concrete' }}</h5>
                    <h2 class="heading">{!! nl2br(e($settings->banner_title ?? "Coatings For Spaces People \n Work, Live & Play In.")) !!}</h2>
                    <div class="index_banner_btn">
                        <a href="{{ url('/contact') }}" class="common_btn">Contact Us</a>
                    </div>
                </div>
            </div>
            <div class="col-12 col-sm-12 col-md-5 col-lg-5 col-xl-5 col-xxl-5">
                <div class="banner_form_main">
                    <img src="{{ asset('assets/front/images/top_tag.png') }}" alt="" class="top_tag_img">
                    <h3 class="banner_form_heading">GET YOUR FREE QUOTE TODAY!</h3>
                    <p class="banner_form_para">Fill out the quick form below and a TechShield flooring expert will
                        contact you within 24 hours to discuss your vision and provide a free quote.</p>
                    <form action="">
                        <div class="row">
                            <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                <div class="form_group">
                                    <input type="text" class="form_control" placeholder="First Name">
                                </div>
                            </div>
                            <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                <div class="form_group">
                                    <input type="text" class="form_control" placeholder="Last Name">
                                </div>
                            </div>
                            <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                <div class="form_group">
                                    <input type="email" class="form_control" placeholder="Email Address">
                                </div>
                            </div>
                            <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                <div class="form_group">
                                    <input type="text" class="form_control" placeholder="Phone Number">
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="form_group">
                                    <textarea name="" id="" class="form_control"
                                        placeholder="Job Description"></textarea>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="form_group">
                                    <label for="">Attachment</label>
                                    <div class="file_upload_box">
                                        <input type="file" class="file_input">
                                        <span class="file_icon">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                                stroke-linecap="round" stroke-linejoin="round"
                                                class="feather feather-paperclip">
                                                <path
                                                    d="M21.44 11.05l-9.19 9.19a6 6 0 0 1-8.49-8.49l9.19-9.19a4 4 0 0 1 5.66 5.66l-9.2 9.19a2 2 0 0 1-2.83-2.83l8.49-8.48">
                                                </path>
                                            </svg>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12">
                                <button type="submit" class="common_btn">SUBMIT NOW</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- About Us Section -->
<section class="about-section">
    <div class="container">
        <div class="row">
            <div class="col-12 text-center mb-5">
                <h2 class="about-main-title">{!! nl2br(e($settings->about_main_title ?? "12 YEARS OF INDUSTRIAL EXPERTISE, TRUSTED\nCRAFTSMANSHIP & ENGINEERED\nDURABILITY.")) !!}</h2>
            </div>
        </div>

        <div class="row align-items-stretch">
            <!-- Left Side: Worker Image -->
            <div class="col-lg-6 col-md-12">
                <div class="about-image-wrapper img_fix">
                    @if($settings && $settings->about_worker_image)
                        <img src="{{ asset('storage/' . $settings->about_worker_image) }}" alt="TechShield Worker" class="about-worker-img">
                    @else
                        <img src="{{ asset('assets/front/images/about-worker.png') }}" alt="TechShield Worker" class="about-worker-img">
                    @endif
                </div>
            </div>

            <!-- Right Side: Content -->
            <div class="col-lg-6 col-md-12">
                <div class="about-content-wrapper">
                    <p class="about-subtitle">{{ $settings->about_subtitle ?? 'ABOUT US' }}</p>
                    <h3 class="about-title">{{ $settings->about_title ?? 'WHO ARE WE?' }}</h3>

                    <!-- Metallic Floor Image -->
                    <div class="about-metallic-img-wrapper">
                        @if($settings && $settings->about_metallic_image)
                            <img src="{{ asset('storage/' . $settings->about_metallic_image) }}" alt="Metallic Epoxy Floor" class="about-metallic-img">
                        @else
                            <img src="{{ asset('assets/front/images/about-metallic.jpg') }}" alt="Metallic Epoxy Floor" class="about-metallic-img">
                        @endif
                    </div>

                    <p class="about-description">
                        {{ $settings->about_description ?? "At TechShield Epoxy Floors, we don't just coat concrete—we engineer lasting systems designed for decades. Our expertise lies in surface preparation, moisture mitigation, and multi-layer epoxy systems designed for both beauty and performance. With over 12 years of experience in industrial coatings, we've earned the trust of homeowners, facility managers, and commercial clients looking for floors that deliver long-term value." }}
                    </p>

                    <!-- Features List (Static for now as requested for text and images mainly) -->
                    <div class="about-features">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="feature-item">
                                    <i class="fas fa-check-circle"></i>
                                    <span>TRUST & INTEGRITY</span>
                                </div>
                                <div class="feature-item">
                                    <i class="fas fa-check-circle"></i>
                                    <span>PROTECTION YOU CAN COUNT ON</span>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="feature-item">
                                    <i class="fas fa-check-circle"></i>
                                    <span>TECHNICAL EXCELLENCE</span>
                                </div>
                                <div class="feature-item">
                                    <i class="fas fa-check-circle"></i>
                                    <span>CRAFTSMANSHIP & CARE</span>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="feature-item">
                                    <i class="fas fa-check-circle"></i>
                                    <span>DEPENDABILITY</span>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="feature-item">
                                    <i class="fas fa-check-circle"></i>
                                    <span>COMMITMENT TO LONGEVITY</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <a href="{{ url('/about') }}" class="btn_black">MORE ABOUT US</a>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- About Us Section End -->

<section class="index_second_wrapper" id="services">
    <div class="container">
        <div class="index_second_wrap_text">
            <h6 class="heading">Our Services</h6>
            <a href="#services" class="common_btn">View All services</a>
        </div>
        <div class="index_second_box">
            @foreach($services as $service)
                <a href="{{ $service->link ?? '#' }}" class="index_second_box_item">
                    <div class="index_second_box_item_text">
                        <h6>{{ $service->title }}</h6>
                    </div>
                    <div class="index_second_box_item_img">
                        @if($service->image)
                            <img src="{{ str_starts_with($service->image, 'assets/') ? asset($service->image) : asset('storage/' . $service->image) }}" class="img-fluid" alt="{{ $service->title }}">
                        @endif
                    </div>
                    <div class="index_second_box_item_text1">
                        <p>{{ $service->description }}</p>
                        <svg xmlns="http://www.w3.org/2000/svg" width="58" height="58" viewBox="0 0 58 58" fill="none">
                            <path d="M3.42432 53.7524L54.8939 2.2829" stroke="#FFF8F8" stroke-width="4" />
                            <path d="M8.09497 2.28296H54.894V49.082" stroke="#FFF8F8" stroke-width="4" />
                        </svg>
                    </div>
                </a>
            @endforeach
        </div>
    </div>
</section>

<!-- Expertise Section -->
<section class="expertise-section">
    <!-- Marquee -->
    <div class="expertise-marquee">
        <div class="marquee-content">
            <span>FLOORS REINFORCED. SPACES ENHANCED • FLOORS REINFORCED. SPACES ENHANCED • FLOORS REINFORCED. SPACES
                ENHANCED • FLOORS REINFORCED. SPACES ENHANCED • FLOORS REINFORCED. SPACES ENHANCED • FLOORS REINFORCED.
                SPACES ENHANCED • </span>
        </div>
    </div>

    <div class="container">
        <div class="row">
            <div class="col-12 text-center">
                <p class="expertise-subtitle">{{ $settings->expertise_subtitle ?? 'EXPERTISE' }}</p>
                <h2 class="expertise-title">{{ $settings->expertise_title ?? 'EXPERT EPOXY COATING INSTALLERS' }}</h2>
                <p class="expertise-description">
                    {{ $settings->expertise_description ?? "At TechShield Epoxy Floors, we don't just coat concrete—we engineer lasting systems designed for decades. Our expertise lies in surface preparation, moisture mitigation, and multi-layer epoxy systems designed for both beauty and performance. Every project is handled with technical accuracy, premium materials, and a commitment to long-term value." }}
                </p>
                <div class="expertise_btn">
                    <button class="btn_black">LEARN MORE</button>
                </div>
            </div>
        </div>

        <div class="row expertise-images">
            <div class="col-lg-3 col-md-6 col-sm-12">
                <div class="expertise-image-wrapper expertise-image-wrapperu1">
                    <img src="{{ asset('assets/front/images/expertise-1.png') }}" alt="Metallic Epoxy Floor Installation"
                        class="expertise-img">
                </div>
            </div>
            <div class="col-lg-6 col-md-6 col-sm-12">
                <div class="expertise-image-wrapper expertise-image-wrapperu2">
                    <img src="{{ asset('assets/front/images/expertise-2.png') }}" alt="Blue Epoxy Floor Installation"
                        class="expertise-img">
                </div>
            </div>
            <div class="col-lg-3 col-md-6 col-sm-12">
                <div class="expertise-image-wrapper expertise-image-wrapperu3">
                    <img src="{{ asset('assets/front/images/expertise-3.png') }}" alt="Commercial Epoxy Floor" class="expertise-img">
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Expertise Section End -->

<!-- Pricing Section (Static for now as it involves complex data structures) -->
<section class="pricing-section">
    <div class="container">
        <div class="row">
            <div class="col-12 text-center mb-5">
                <h2 class="pricing-title">CLEAR PRICING FOR PREMIUM<br>EPOXY SERVICES</h2>
            </div>
        </div>

        <div class="pricing_slider swiper">
            <div class="swiper-wrapper">
                <!-- Card 1: Solid Color -->
                <div class="swiper-slide">
                    <div class="pricing-card">
                        <span class="pricing-badge badge-best">BEST</span>
                        <div class="pricing-header">
                            <div class="price-tag">
                                <span class="currency">$3</span>
                                <span class="sq-text">SQ/FEET SQ/FT</span>
                            </div>
                            <h3 class="pricing-card-title">SOLID COLOR</h3>
                            <p class="pricing-subtitle">VARIETY OF COLORS</p>
                        </div>
                        <div class="pricing-features">
                            <ul>
                                <li><i class="fas fa-check"></i> Diamond Grinding/Shot Blast Surface Preparation</li>
                                <li><i class="fas fa-check"></i> Moisture Vapor Barrier/100% Solids Industrial Grade
                                    Base
                                    Coat</li>
                                <li><i class="fas fa-check"></i> Full Broadcast Of Decorative Flakes</li>
                                <li><i class="fas fa-check"></i> Premium High Gloss Polyaspartic Top Coat</li>
                            </ul>
                        </div>
                        <div class="pricing-footer">
                            <button class="btn_black btn-learn-more">LEARN MORE</button>
                        </div>
                    </div>
                </div>

                <!-- Card 2: Full Flakes -->
                <div class="swiper-slide">
                    <div class="pricing-card">
                        <span class="pricing-badge badge-better">BETTER</span>
                        <div class="pricing-header">
                            <div class="price-tag">
                                <span class="currency">$4</span>
                                <span class="sq-text">SQ/FEET SQ/FT</span>
                            </div>
                            <h3 class="pricing-card-title">FULL FLAKES</h3>
                            <p class="pricing-subtitle">VARIETY OF COLORS</p>
                        </div>
                        <div class="pricing-features">
                            <ul>
                                <li><i class="fas fa-check"></i> Diamond Grinding/Shot Blast Surface Preparation</li>
                                <li><i class="fas fa-check"></i> Moisture Vapor Barrier/100% Solids Industrial Grade
                                    Base
                                    Coat</li>
                                <li><i class="fas fa-check"></i> Full Broadcast Of Decorative Flakes</li>
                                <li><i class="fas fa-check"></i> Premium High Gloss Polyaspartic Top Coat</li>
                            </ul>
                        </div>
                        <div class="pricing-footer">
                            <button class="btn_black btn-learn-more">LEARN MORE</button>
                        </div>
                    </div>
                </div>

                <!-- Card 3: Quartz -->
                <div class="swiper-slide">
                    <div class="pricing-card">
                        <span class="pricing-badge badge-best">BEST</span>
                        <div class="pricing-header">
                            <div class="price-tag">
                                <span class="currency">$6</span>
                                <span class="sq-text">SQ/FEET SQ/FT</span>
                            </div>
                            <h3 class="pricing-card-title">QUARTZ</h3>
                            <p class="pricing-subtitle">VARIETY OF COLORS</p>
                        </div>
                        <div class="pricing-features">
                            <ul>
                                <li><i class="fas fa-check"></i> Diamond Grinding/Shot Blast Surface Preparation</li>
                                <li><i class="fas fa-check"></i> Primer/Sealer</li>
                                <li><i class="fas fa-check"></i> Moisture Vapor Barrier/100% Solids Industrial Grade
                                    Base
                                    Coat</li>
                                <li><i class="fas fa-check"></i> Full Broadcast Of Quartz</li>
                                <li><i class="fas fa-check"></i> Premium High Gloss Polyaspartic Top Coat</li>
                            </ul>
                        </div>
                        <div class="pricing-footer">
                            <button class="btn_black btn-learn-more">LEARN MORE</button>
                        </div>
                    </div>
                </div>

                <!-- Card 4: Metallic -->
                <div class="swiper-slide">
                    <div class="pricing-card">
                        <span class="pricing-badge badge-premium">PREMIUM</span>
                        <div class="pricing-header">
                            <div class="price-tag">
                                <span class="currency">$8</span>
                                <span class="sq-text">SQ/FEET SQ/FT</span>
                            </div>
                            <h3 class="pricing-card-title">METALLIC</h3>
                            <p class="pricing-subtitle">VARIETY OF COLORS</p>
                        </div>
                        <div class="pricing-features">
                            <ul>
                                <li><i class="fas fa-check"></i> Diamond Grinding/Shot Blast Surface Preparation</li>
                                <li><i class="fas fa-check"></i> Moisture Vapor Barrier/100% Solids Industrial Grade
                                    Base
                                    Coat</li>
                                <li><i class="fas fa-check"></i> Premium High Gloss Polyaspartic Top Coat</li>
                                <li><i class="fas fa-check"></i> Metallic Color Designer Coat</li>
                            </ul>
                        </div>
                        <div class="pricing-footer">
                            <button class="btn_black btn-learn-more">LEARN MORE</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="pricing-pagination swiper-pagination"></div>
        </div>
    </div>
</section>
<!-- Pricing Section End -->

<!-- Blog Section (Static for now) -->
<section class="blog-section">
    <div class="container">
        <div class="row align-items-center mb-4">
            <div class="col-lg-8 col-md-7">
                <p class="blog-subtitle">OUR NEWS</p>
                <h2 class="blog-title">FLOORING TIPS,<br>GUIDES & UPDATES</h2>
            </div>
            <div class="col-lg-4 col-md-5">
                <div class="blog_btn">
                    <button class="btn_black">VIEW ALL BLOGS</button>
                </div>
            </div>
        </div>
        <div class="blog_slider">
            <div class="swiper blog-swiper">
                <div class="swiper-wrapper">
                    <div class="swiper-slide">
                        <div class="blog-card">
                            <div class="blog-image">
                                <img src="{{ asset('assets/front/images/blog-1.png') }}" alt="How Long Epoxy Floors Last">
                            </div>
                            <div class="blog-content">
                                <p class="blog-date">28 OCT 2025</p>
                                <h3 class="blog-card-title">How Long Epoxy Floors Last & 5 Tips</h3>
                                <button class="btn_black">LEARN MORE</button>
                            </div>
                        </div>
                    </div>
                    <!-- Add more slides if needed -->
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Blog Section End -->

<!-- Testimonials Section -->
<section class="testimonials-section">
    <div class="container">
        <div class="row">
            <div class="col-12 text-start mb-sm-5">
                <h2 class="testimonials-title">WHAT PEOPLE ARE TALKING<br>ABOUT TECHSHIELD</h2>
            </div>
        </div>

        <div class="testimonials-slider-wrapper">
            <!-- Swiper -->
            <div class="swiper testimonials-swiper">
                <div class="swiper-wrapper">
                    @foreach($testimonials as $testimonial)
                        <div class="swiper-slide">
                            <div class="testimonial-card">
                                <div class="testimonial-image">
                                    @if($testimonial->image)
                                        <img src="{{ str_starts_with($testimonial->image, 'assets/') ? asset($testimonial->image) : asset('storage/' . $testimonial->image) }}" alt="{{ $testimonial->name }}">
                                    @endif
                                </div>
                                <div class="testimonial-content">
                                    <div class="quote-icon">
                                        <svg width="40" height="32" viewBox="0 0 40 32" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M0 32V16C0 7.168 4.8 0 17.6 0V6.4C11.2 6.4 8 9.6 8 16H17.6V32H0ZM22.4 32V16C22.4 7.168 27.2 0 40 0V6.4C33.6 6.4 30.4 9.6 30.4 16H40V32H22.4Z"
                                                fill="#DC2626" />
                                        </svg>
                                    </div>
                                    <p class="testimonial-text">"{{ $testimonial->content }}"</p>
                                    <div class="testimonial-author">
                                        <p class="author-name">— {{ $testimonial->name }}, {{ $testimonial->role }}</p>
                                        <p class="author-role">Customer</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>

            <!-- Navigation Buttons -->
            <div class="testimonials-navigation">
                <button class="testimonial-btn-prev">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M15 18L9 12L15 6" stroke="white" stroke-width="2" stroke-linecap="round"
                            stroke-linejoin="round" />
                    </svg>
                </button>
                <button class="testimonial-btn-next">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M9 18L15 12L9 6" stroke="white" stroke-width="2" stroke-linecap="round"
                            stroke-linejoin="round" />
                    </svg>
                </button>
            </div>
        </div>
    </div>
</section>
<!-- Testimonials Section End -->

<!-- Gallery Section -->
<section class="gallery-section">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="gallery-content">
                    <p class="gallery-subtitle">OUR RECENT GALLERY</p>
                    <h2 class="gallery-title">SHOWCASE OF OUR<br>FLOORING SOLUTIONS</h2>
                </div>
            </div>
        </div>
    </div>

    <div class="gallery-slider-wrapper">
        <!-- Swiper -->
        <div class="swiper gallery-swiper">
            <div class="swiper-wrapper">
                @foreach($galleryItems as $item)
                    <div class="swiper-slide">
                        <div class="gallery-image">
                            <img src="{{ str_starts_with($item->image, 'assets/') ? asset($item->image) : asset('storage/' . $item->image) }}" alt="{{ $item->caption }}">
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
</section>
<!-- Gallery Section End -->

@include('front.inc.footer')