<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>{{ config('app.name', 'Tech Shield') }}</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0,user-scalable=no">
    <meta name="robots" content="noindex" />
    <link rel="icon" href="{{ asset('assets/front/images/favicon.ico') }}">
    <link rel="stylesheet" href="{{ asset('assets/front/css/bootstrap.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/front/css/swiper-bundle.min.css') }}" />
    <link rel="stylesheet" href="{{ asset('assets/front/css/all.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/front/css/main.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/front/css/responsive.css') }}">
</head>

<body>
    <div id="smooth-wrapper">
        <div id="smooth-content">
            <header class="header_wrapper">
                <div class="container">
                    <div class="header-main-mob-logo">
                        <a href="{{ url('/') }}"><img src="{{ asset('assets/front/images/logo.png') }}" class="img-fluid" alt=""></a>
                        <div class="header-menu">
                            <i class="fa-solid fa-bars"></i>
                        </div>
                    </div>
                    <div class="header_main_f">
                        <div class="header_main_logo">
                            <a href="{{ url('/') }}"><img src="{{ asset('assets/front/images/logo.png') }}" class="img-fluid" alt=""></a>
                        </div>
                        <div class="header_main_links header-main-flex">
                            <ul>
                                <li><a href="{{ url('/') }}">Home</a></li>
                                <li><a href="{{ url('/about') }}">About</a></li>
                                <li class="has_dropdown">
                                    <a href="javascript:void(0)">services <i class="fas fa-chevron-down"></i></a>
                                    <ul class="dropdown_menu">
                                        @foreach(\App\Models\Service::all() as $service)
                                            <li><a href="{{ $service->link ?? '#' }}">{{ $service->title }}</a></li>
                                        @endforeach
                                    </ul>
                                </li>
                                <li><a href="{{ url('/pricing') }}">Pricing</a></li>
                                <li><a href="{{ url('/faq') }}">FAQ</a></li>
                                <li><a href="{{ url('/gallery') }}">Gallery</a></li>
                                <li><a href="{{ url('/contact') }}">Contact</a></li>
                            </ul>
                            <div class="header_main_btn">
                                <a href="{{ url('/admin/login') }}" class="common_outline_btn">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="18" viewBox="0 0 16 18"
                                        fill="none">
                                        <path
                                            d="M7.62791 7.6279C9.7343 7.6279 11.4419 5.92034 11.4419 3.81395C11.4419 1.70756 9.7343 0 7.62791 0C5.52153 0 3.81396 1.70756 3.81396 3.81395C3.81396 5.92034 5.52153 7.6279 7.62791 7.6279Z"
                                            fill="var(--white)" />
                                        <path
                                            d="M15.2558 12.8721C15.2558 15.2415 15.2558 17.1628 7.6279 17.1628C0 17.1628 0 15.2415 0 12.8721C0 10.5027 3.41539 8.58139 7.6279 8.58139C11.8404 8.58139 15.2558 10.5027 15.2558 12.8721Z"
                                            fill="var(--white)" />
                                    </svg>
                                    Admin Login
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </header>