@include('front.inc.header')

<section class="inner_banner_wrapper">
    <div class="container">
        <div class="inner_banner_text">
            <h5 class="sub_heading">Flake System</h5>
            <h2 class="heading">Flake System — Our Most Popular Flooring Option</h2>
        </div>
    </div>
</section>

<section class="service_detail_wrapper">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6">
                <div class="service_detail_img">
                    <img src="{{ asset('assets/front/images/sec_img2.png') }}" alt="Flake System" class="img-fluid">
                </div>
            </div>
            <div class="col-lg-6">
                <div class="service_detail_text">
                    <p class="section_subtitle">PREMIUM COATING</p>
                    <h3 class="section_title">Our Flake System</h3>
                    <p class="section_desc">
                        Our Flake System combines durability, safety, and visual appeal, making it the most popular
                        choice among homeowners and commercial clients. Choose from Twenty five designer color blends or
                        let us create a custom combination to complement your décor or team colors.
                    </p>
                    <p class="section_desc">
                        Built with a three-layer polyaspartic system, this floor delivers a non-slip, UV-stable, and
                        highly durable surface ideal for garages, schools, locker rooms, and showrooms. Formulated with
                        100% polyaspartic solids, it offers outstanding chemical, abrasion, and impact resistance,
                        ensuring long-term protection and a beautiful, easy-to-maintain finish.
                    </p>
                    <div class="service_btn_box">
                        <a href="{{ url('/pricing') }}" class="common_btn">View Pricing</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="specifications_wrapper">
    <div class="container">
        <div class="spec_main_box">
            <div class="feature_icon_box_m">
                <div class="row g-4 text-center">
                    <div class="col-6 col-md-3">
                        <div class="feature_icon_box">
                            <div class="icon_circle">
                                <i class="fas fa-shield-alt"></i>
                            </div>
                            <h5>Chip Resistant</h5>
                        </div>
                    </div>
                    <div class="col-6 col-md-3">
                        <div class="feature_icon_box">
                            <div class="icon_circle">
                                <i class="fas fa-vial"></i>
                            </div>
                            <h5>Chemical Resistance</h5>
                        </div>
                    </div>
                    <div class="col-6 col-md-3">
                        <div class="feature_icon_box">
                            <div class="icon_circle">
                                <i class="fas fa-gem"></i>
                            </div>
                            <h5>Scratch Resistance</h5>
                        </div>
                    </div>
                    <div class="col-6 col-md-3">
                        <div class="feature_icon_box">
                            <div class="icon_circle">
                                <i class="fas fa-sun"></i>
                            </div>
                            <h5>UV Resistance</h5>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-6">
                    <div class="spec_list">
                        <ul>
                            <li><i class="fas fa-check-circle"></i> Mold and Bacteria Proof</li>
                            <li><i class="fas fa-check-circle"></i> Scratch Resistant</li>
                            <li><i class="fas fa-check-circle"></i> Chemical Resistant</li>
                            <li><i class="fas fa-check-circle"></i> Colors Of Choice</li>
                        </ul>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="spec_info_box">
                        <div class="info_item">
                            <span class="label">Installation Time:</span>
                            <span class="value">1-2 Day Installation</span>
                        </div>
                        <div class="info_item">
                            <span class="label">Dry Times:</span>
                            <span class="value">24 Hour Foot Traffic, 3 Day Drive On</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="gallery-section">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="gallery-content">
                    <p class="gallery-subtitle">OUR RECENT GALLERY</p>
                    <h2 class="gallery-title">SHOWCASE OF OUR<br>FLAKE SYSTEM</h2>
                </div>
            </div>
        </div>
    </div>

    <div class="gallery-slider-wrapper">
        <!-- Swiper -->
        <div class="swiper gallery-swiper">
            <div class="swiper-wrapper">
                <!-- Gallery Image 1 -->
                <div class="swiper-slide">
                    <div class="gallery-image">
                        <img src="{{ asset('assets/front/images/gallery3.png') }}" alt="Residential Flake Floor">
                    </div>
                </div>

                <!-- Gallery Image 2 -->
                <div class="swiper-slide">
                    <div class="gallery-image">
                        <img src="{{ asset('assets/front/images/gallery1.png') }}" alt="Flake System Floor">
                    </div>
                </div>

                <!-- Gallery Image 3 -->
                <div class="swiper-slide">
                    <div class="gallery-image">
                        <img src="{{ asset('assets/front/images/gallery2.png') }}" alt="Commercial Flake Floor">
                    </div>
                </div>

                <!-- Duplicate for loop -->
                <div class="swiper-slide">
                    <div class="gallery-image">
                        <img src="{{ asset('assets/front/images/about-metallic.jpg') }}" alt="Flake Detail">
                    </div>
                </div>

                <div class="swiper-slide">
                    <div class="gallery-image">
                        <img src="{{ asset('assets/front/images/gallery1.png') }}" alt="Flake Finish">
                    </div>
                </div>
            </div>
        </div>

        <!-- Navigation Buttons -->
        <div class="gallery-navigation">
            <button class="gallery-btn-prev">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M15 18L9 12L15 6" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                        stroke-linejoin="round" />
                </svg>
            </button>
            <button class="gallery-btn-next">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M9 18L15 12L9 6" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                        stroke-linejoin="round" />
                </svg>
            </button>
        </div>
    </div>
</section>

@include('front.inc.footer')