@include('front.inc.header')

<section class="inner_banner_wrapper">
    <div class="container">
        <div class="inner_banner_text">
            <h5 class="sub_heading">HELP CENTER</h5>
            <h2 class="heading">Frequently Asked Questions</h2>
        </div>
    </div>
</section>

<section class="faq_wrapper section_padding">
    <div class="container">
        <div class="row">
            <div class="col-lg-12 text-center mb-5">
                <p class="section_subtitle">GOT QUESTIONS?</p>
                <h2 class="section_title">Answers to Common Flooring Questions</h2>
                <p class="section_desc">Find everything you need to know about our epoxy and polyaspartic systems.</p>
            </div>
        </div>

        <div class="faq_container">
            <div class="accordion" id="faqAccordion">
                <!-- Question 1 -->
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingOne">
                        <button class="accordion-button" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                            How long does an epoxy floor last?
                        </button>
                    </h2>
                    <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne"
                        data-bs-parent="#faqAccordion">
                        <div class="accordion-body">
                            With proper installation and care, TechShield epoxy floors typically last 10–20 years
                            depending on traffic, environment, and maintenance.
                        </div>
                    </div>
                </div>

                <!-- Question 2 -->
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingTwo">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                            Can epoxy floors be installed in homes?
                        </button>
                    </h2>
                    <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo"
                        data-bs-parent="#faqAccordion">
                        <div class="accordion-body">
                            Absolutely. Epoxy is great for garages, basements, kitchens, patios, and interior spaces
                            where durability and easy cleaning matter.
                        </div>
                    </div>
                </div>

                <!-- Question 3 -->
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingThree">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                            How long does installation take?
                        </button>
                    </h2>
                    <div id="collapseThree" class="accordion-collapse collapse" aria-labelledby="headingThree"
                        data-bs-parent="#faqAccordion">
                        <div class="accordion-body">
                            Most residential jobs are completed in 1–3 days, depending on floor size, prep requirements,
                            and curing conditions.
                        </div>
                    </div>
                </div>

                <!-- Question 4 -->
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingFour">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                            Can epoxy be applied over old concrete?
                        </button>
                    </h2>
                    <div id="collapseFour" class="accordion-collapse collapse" aria-labelledby="headingFour"
                        data-bs-parent="#faqAccordion">
                        <div class="accordion-body">
                            Yes, as long as the concrete is structurally sound. Our team grinds, repairs, and prepares
                            the surface to ensure maximum adhesion.
                        </div>
                    </div>
                </div>

                <!-- Question 5 -->
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingFive">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseFive" aria-expanded="false" aria-controls="collapseFive">
                            Do you offer warranty coverage?
                        </button>
                    </h2>
                    <div id="collapseFive" class="accordion-collapse collapse" aria-labelledby="headingFive"
                        data-bs-parent="#faqAccordion">
                        <div class="accordion-body">
                            Yes. We stand behind our systems with a multi-year workmanship and product warranty,
                            depending on the type of coating installed.
                        </div>
                    </div>
                </div>

                <!-- Question 6 -->
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingSix">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseSix" aria-expanded="false" aria-controls="collapseSix">
                            What’s the difference between flake and metallic epoxy systems?
                        </button>
                    </h2>
                    <div id="collapseSix" class="accordion-collapse collapse" aria-labelledby="headingSix"
                        data-bs-parent="#faqAccordion">
                        <div class="accordion-body">
                            Flake systems are textured, durable, and ideal for heavy-use areas. Metallic systems are
                            smooth, decorative, and perfect for luxury interiors.
                        </div>
                    </div>
                </div>

                <!-- Question 7 -->
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingSeven">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseSeven" aria-expanded="false" aria-controls="collapseSeven">
                            Can you match colors or company branding?
                        </button>
                    </h2>
                    <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingSeven"
                        data-bs-parent="#faqAccordion">
                        <div class="accordion-body">
                            Definitely! We offer custom colors and design patterns that match your brand palette or home
                            style.
                        </div>
                    </div>
                </div>

                <!-- Question 8 -->
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingEight">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseEight" aria-expanded="false" aria-controls="collapseEight">
                            How soon can I use my new floor after installation?
                        </button>
                    </h2>
                    <div id="collapseEight" class="accordion-collapse collapse" aria-labelledby="headingEight"
                        data-bs-parent="#faqAccordion">
                        <div class="accordion-body">
                            Floors are usually walkable within 24 hours and ready for vehicles in 72 hours, depending on
                            weather and curing conditions.
                        </div>
                    </div>
                </div>

                <!-- Question 9 -->
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingNine">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseNine" aria-expanded="false" aria-controls="collapseNine">
                            How do I maintain my epoxy floor?
                        </button>
                    </h2>
                    <div id="collapseNine" class="accordion-collapse collapse" aria-labelledby="headingNine"
                        data-bs-parent="#faqAccordion">
                        <div class="accordion-body">
                            Sweep regularly and use mild detergent with warm water for cleaning. Avoid harsh chemicals
                            and abrasive pads to preserve the shine.
                        </div>
                    </div>
                </div>
            </div>

            <div class="faq_contact_box text-center mt-5">
                <h4>Still have questions?</h4>
                <p>Our team is ready to help you with your flooring project.</p>
                <a href="#!" class="common_btn mt-3">Contact Us Today</a>
            </div>
        </div>
    </div>
</section>

@include('front.inc.footer')