@include('front.inc.header')

<section class="inner_banner_wrapper">
    <div class="container">
        <div class="inner_banner_text">
            <h5 class="sub_heading">Cementitious Coatings</h5>
            <h2 class="heading">Cementitious — Strength Meet Aesthetics</h2>
        </div>
    </div>
</section>

<section class="service_detail_wrapper">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6">
                <div class="service_detail_img">
                    <img src="{{ asset('assets/front/images/sec_img3.png') }}" alt="Cementitious Coatings" class="img-fluid">
                </div>
            </div>
            <div class="col-lg-6">
                <div class="service_detail_text">
                    <p class="section_subtitle">YES, IT'S CONCRETE</p>
                    <h3 class="section_title">Resurfacing & Overlays</h3>
                    <p class="section_desc">
                        Our Cementitious coatings offer exceptional strength, moisture resistance, and longevity—ideal
                        for high-traffic indoor and outdoor surfaces. These systems are designed to resurface and
                        transform existing concrete into beautiful, functional spaces.
                    </p>
                    <p class="section_desc">
                        From the majestic look of <strong>Concrete Grand Flagstone</strong> to the warm, timeless appeal
                        of <strong>Concrete Rustic Wood</strong>, our overlays provide the look of natural materials
                        with the unmatched durability of concrete. These systems are UV stable, slip-resistant, and
                        built to withstand the elements.
                    </p>
                    <div class="service_btn_box">
                        <a href="{{ url('/pricing') }}" class="common_btn">View Pricing</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="specifications_wrapper">
    <div class="container">
        <div class="spec_main_box">
            <div class="feature_icon_box_m">
                <div class="row g-4 text-center">
                    <div class="col-6 col-md-3">
                        <div class="feature_icon_box">
                            <div class="icon_circle">
                                <i class="fas fa-hammer"></i>
                            </div>
                            <h5>Extreme Strength</h5>
                        </div>
                    </div>
                    <div class="col-6 col-md-3">
                        <div class="feature_icon_box">
                            <div class="icon_circle">
                                <i class="fas fa-tint-slash"></i>
                            </div>
                            <h5>Moisture Proof</h5>
                        </div>
                    </div>
                    <div class="col-6 col-md-3">
                        <div class="feature_icon_box">
                            <div class="icon_circle">
                                <i class="fas fa-walking"></i>
                            </div>
                            <h5>Non-Slip Surface</h5>
                        </div>
                    </div>
                    <div class="col-6 col-md-3">
                        <div class="feature_icon_box">
                            <div class="icon_circle">
                                <i class="fas fa-sun"></i>
                            </div>
                            <h5>UV Stable</h5>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-6">
                    <div class="spec_list">
                        <ul>
                            <li><i class="fas fa-check-circle"></i> Grand Flagstone Patterns</li>
                            <li><i class="fas fa-check-circle"></i> Rustic Wood Finishes</li>
                            <li><i class="fas fa-check-circle"></i> High Traffic Rated</li>
                            <li><i class="fas fa-check-circle"></i> Low Maintenance</li>
                        </ul>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="spec_info_box">
                        <div class="info_item">
                            <span class="label">Installation Time:</span>
                            <span class="value">3-5 Day Installation</span>
                        </div>
                        <div class="info_item">
                            <span class="label">Ideal For:</span>
                            <span class="value">Patios, Pool Decks, & Driveways</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="gallery-section">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="gallery-content">
                    <p class="gallery-subtitle">OUR RECENT GALLERY</p>
                    <h2 class="gallery-title">SHOWCASE OF OUR<br>CEMENTITIOUS SYSTEMS</h2>
                </div>
            </div>
        </div>
    </div>

    <div class="gallery-slider-wrapper">
        <!-- Swiper -->
        <div class="swiper gallery-swiper">
            <div class="swiper-wrapper">
                <!-- Gallery Image 1 -->
                <div class="swiper-slide">
                    <div class="gallery-image">
                        <img src="{{ asset('assets/front/images/gallery3.png') }}" alt="Grand Flagstone Patio">
                    </div>
                </div>

                <!-- Gallery Image 2 -->
                <div class="swiper-slide">
                    <div class="gallery-image">
                        <img src="{{ asset('assets/front/images/gallery1.png') }}" alt="Rustic Wood Concrete">
                    </div>
                </div>

                <!-- Gallery Image 3 -->
                <div class="swiper-slide">
                    <div class="gallery-image">
                        <img src="{{ asset('assets/front/images/gallery2.png') }}" alt="Cementitious Driveway">
                    </div>
                </div>

                <!-- Duplicate for loop -->
                <div class="swiper-slide">
                    <div class="gallery-image">
                        <img src="{{ asset('assets/front/images/about-worker.png') }}" alt="Installation Detail">
                    </div>
                </div>

                <div class="swiper-slide">
                    <div class="gallery-image">
                        <img src="{{ asset('assets/front/images/gallery1.png') }}" alt="Finished Surface">
                    </div>
                </div>
            </div>
        </div>

        <!-- Navigation Buttons -->
        <div class="gallery-navigation">
            <button class="gallery-btn-prev">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M15 18L9 12L15 6" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                        stroke-linejoin="round" />
                </svg>
            </button>
            <button class="gallery-btn-next">
                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M9 18L15 12L9 6" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                        stroke-linejoin="round" />
                </svg>
            </button>
        </div>
    </div>
</section>

@include('front.inc.footer')