@include('front.inc.header')

<section class="inner_banner_wrapper">
    <div class="container">
        <div class="inner_banner_text">
            <h5 class="sub_heading">About us</h5>
            <h2 class="heading">Industrial Expertise. Trusted <br> Craftsmanship. Engineered to Last.</h2>
        </div>
    </div>
</section>

<section class="who_we_are_wrapper">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6">
                <div class="who_we_are_img img_fix">
                    <img src="{{ asset('assets/front/images/about-worker.png') }}" alt="Who We Are" class="img-fluid">
                </div>
            </div>
            <div class="col-lg-6">
                <div class="who_we_are_text">
                    <p class="section_subtitle">WHO ARE WE?</p>
                    <h3 class="section_title">Techshield Epoxy Floors</h3>
                    <p class="section_desc">
                        At Techshield Epoxy Floors, we understand that your floor is more than just a surface, it’s part
                        of your home, your business, and your daily life. That’s why our promise goes beyond
                        great-looking results: we deliver trust, reliability, and long-term performance you can depend
                        on.
                    </p>
                    <p class="section_desc">
                        With over 12 years of experience in industrial coatings and as an AMPP Certified Coatings
                        Inspector, we founded Techshield Epoxy Floors to bring the same industrial-grade quality,
                        precision, and professionalism once reserved for large facilities, right into the residential
                        and commercial spaces of our local community.
                    </p>
                    <p class="section_desc">
                        Our background includes years of hands-on experience in surface preparation, inspection, and
                        quality control on high-demand industrial projects like refineries, plants, and
                        performance-critical environments where failure isn’t an option. That same standard of
                        discipline, detail, and durability is what defines every floor we install today.
                    </p>
                    <p class="section_desc">
                        We specialize in epoxy and polyaspartic coating systems that are engineered for performance and
                        designed for beauty. Whether it’s a garage, warehouse, or commercial kitchen, our coatings are
                        crafted to last, using premium materials, proven preparation methods, and precise installation
                        techniques that meet or exceed industry standards.
                    </p>
                    <p class="section_desc">
                        As a locally owned and operated business in Katy, Texas, we take pride in being the company you
                        can count on, showing up when we say we will, communicating clearly, and standing behind our
                        work. Every project we take on is personal, because your floor reflects our reputation.
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="our_values_wrapper">
    <div class="container">
        <div class="text-center mb-5">
            <p class="section_subtitle">Our Values</p>
            <h3 class="section_title text-white">Core Values</h3>
        </div>
        <div class="row g-4">
            <div class="col-lg-4 col-md-6">
                <div class="value_card">
                    <div class="value_number">01</div>
                    <h4>Trust & Integrity</h4>
                    <p>We believe strong relationships are built on honesty. We do what we say we’ll do—every time.</p>
                </div>
            </div>
            <div class="col-lg-4 col-md-6">
                <div class="value_card">
                    <div class="value_number">02</div>
                    <h4>Technical Excellence</h4>
                    <p>As certified professionals, we follow the same standards used in industrial environments to
                        ensure every floor meets the highest level of performance and protection.</p>
                </div>
            </div>
            <div class="col-lg-4 col-md-6">
                <div class="value_card">
                    <div class="value_number">03</div>
                    <h4>Dependability</h4>
                    <p>We show up, we communicate clearly, and we stand behind our work. Your peace of mind is our
                        priority.</p>
                </div>
            </div>
            <div class="col-lg-4 col-md-6">
                <div class="value_card">
                    <div class="value_number">04</div>
                    <h4>Craftsmanship & Care</h4>
                    <p>We treat every project as if it were our own because your floor is a reflection of our
                        reputation.</p>
                </div>
            </div>
            <div class="col-lg-4 col-md-6">
                <div class="value_card">
                    <div class="value_number">05</div>
                    <h4>Commitment to Longevity</h4>
                    <p>From materials to methods, every Techshield floor is built with one goal in mind: lasting
                        protection you can count on.</p>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="vision_mission_wrapper">
    <div class="container">
        <div class="row g-5">
            <div class="col-lg-6">
                <div class="vision_box">
                    <p class="section_subtitle">Our Vision</p>
                    <h3 class="section_title text-white">Vision</h3>
                    <p>To set the standard for performance coatings in the residential and commercial market by applying
                        industrial-grade practices, certified expertise, and advanced materials that redefine what
                        lasting protection means for every surface we touch</p>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="mission_box">
                    <p class="section_subtitle">Our Mission</p>
                    <h3 class="section_title text-white">Mission</h3>
                    <p>To apply industrial-grade coating technology with precision and accountability, delivering
                        durable, safe, and visually striking floors for residential, commercial, and industrial clients.
                        Through certified inspection practices, premium materials, and disciplined workmanship, we
                        ensure every surface meets or exceeds performance expectations and is truly engineered to last.
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>

@include('front.inc.footer')