<?php

namespace Database\Seeders;

use App\Models\HomeSetting;
use App\Models\Service;
use App\Models\Testimonial;
use App\Models\GalleryItem;
use Illuminate\Database\Seeder;

class DefaultContentSeeder extends Seeder
{
    public function run(): void
    {
        HomeSetting::updateOrCreate(['id' => 1], [
            'banner_subtitle' => 'TechShield Epoxy Floors - Premium Concrete',
            'banner_title' => 'Coatings For Spaces People Work, Live & Play In.',
            'banner_video' => 'assets/front/images/banner_vid.mp4',
            'about_main_title' => '12 YEARS OF INDUSTRIAL EXPERTISE, TRUSTED CRAFTSMANSHIP & ENGINEERED DURABILITY.',
            'about_subtitle' => 'ABOUT US',
            'about_title' => 'WHO ARE WE?',
            'about_description' => "At TechShield Epoxy Floors, we don't just coat concrete—we engineer lasting systems designed for decades. Our expertise lies in surface preparation, moisture mitigation, and multi-layer epoxy systems designed for both beauty and performance. With over 12 years of experience in industrial coatings, we've earned the trust of homeowners, facility managers, and commercial clients looking for floors that deliver long-term value.",
            'about_worker_image' => 'assets/front/images/about-worker.png',
            'about_metallic_image' => 'assets/front/images/about-metallic.jpg',
            'expertise_subtitle' => 'EXPERTISE',
            'expertise_title' => 'EXPERT EPOXY COATING INSTALLERS',
            'expertise_description' => "At TechShield Epoxy Floors, we don't just coat concrete—we engineer lasting systems designed for decades. Our expertise lies in surface preparation, moisture mitigation, and multi-layer epoxy systems designed for both beauty and performance. Every project is handled with technical accuracy, premium materials, and a commitment to long-term value.",
        ]);

        $services = [
            [
                'title' => 'Metallic Flooring',
                'description' => 'Our Metallic Epoxy System offers a sleek, one-of-a-kind look that transforms ordinary concrete into a work of art.',
                'image' => 'assets/front/images/sec_img1.png',
                'link' => 'metallic-flooring.php',
            ],
            [
                'title' => 'Flakes System',
                'description' => 'Our Flake System combines durability, safety, and visual appeal, making it the most popular choice among homeowners and commercial clients.',
                'image' => 'assets/front/images/sec_img2.png',
                'link' => 'flakes-system.php',
            ],
            [
                'title' => 'Cementitious',
                'description' => 'Cementitious coatings offer exceptional strength, moisture resistance, and longevity—ideal for high-traffic indoor and outdoor surfaces.',
                'image' => 'assets/front/images/sec_img3.png',
                'link' => 'cementitious.php',
            ],
            [
                'title' => 'Solid Colors',
                'description' => 'Our Solid Color Epoxy System is a classic choice for customers who want a clean, professional finish with long-term reliability.',
                'image' => 'assets/front/images/sec_img4.png',
                'link' => 'solid-colors.php',
            ],
        ];

        foreach ($services as $service) {
            Service::updateOrCreate(['title' => $service['title']], $service);
        }

        $testimonials = [
            [
                'name' => 'James P.',
                'role' => 'Homeowner',
                'content' => 'Our garage looks better than a showroom! The team was punctual, professional, and the finish is flawless. Worth every penny.',
                'image' => 'assets/front/images/testimonial-user-1.png',
            ],
            [
                'name' => 'Lena K.',
                'role' => 'Facility Manager',
                'content' => 'We used TechShield for our warehouse renovation. The floor can handle forklifts all day and still looks brand new months later.',
                'image' => 'assets/front/images/testimonial-user-2.png',
            ],
        ];

        foreach ($testimonials as $testimonial) {
            Testimonial::updateOrCreate(['name' => $testimonial['name']], $testimonial);
        }

        $gallery = [
            ['image' => 'assets/front/images/gallery3.png', 'caption' => 'Residential Epoxy Floor'],
            ['image' => 'assets/front/images/gallery1.png', 'caption' => 'Metallic Epoxy Floor'],
            ['image' => 'assets/front/images/gallery2.png', 'caption' => 'Commercial Epoxy Floor'],
        ];

        foreach ($gallery as $item) {
            GalleryItem::updateOrCreate(['image' => $item['image']], $item);
        }
    }
}
