<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('home_settings', function (Blueprint $table) {
            $table->id();
            // Banner
            $table->string('banner_subtitle')->nullable();
            $table->string('banner_title')->nullable();
            $table->string('banner_video')->nullable();
            // About
            $table->string('about_main_title')->nullable();
            $table->string('about_subtitle')->nullable();
            $table->string('about_title')->nullable();
            $table->text('about_description')->nullable();
            $table->string('about_worker_image')->nullable();
            $table->string('about_metallic_image')->nullable();
            // Expertise
            $table->string('expertise_subtitle')->nullable();
            $table->string('expertise_title')->nullable();
            $table->text('expertise_description')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('home_settings');
    }
};
