<?php

namespace App\Filament\Pages;

use App\Models\HomeSetting;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Form;
use Filament\Pages\Page;
use Filament\Actions\Action;
use Filament\Notifications\Notification;

class ManageHomeSettings extends Page
{
    protected static \BackedEnum|string|null $navigationIcon = \Filament\Support\Icons\Heroicon::OutlinedCog6Tooth;

    protected string $view = 'filament.pages.manage-home-settings';

    public ?array $data = [];

    public function mount(): void
    {
        $settings = HomeSetting::first();
        if ($settings) {
            $this->form->fill($settings->toArray());
        }
    }

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Section::make('Banner Settings')
                    ->schema([
                        TextInput::make('banner_subtitle'),
                        TextInput::make('banner_title'),
                        FileUpload::make('banner_video')
                            ->directory('banner'),
                    ]),
                Section::make('About Section')
                    ->schema([
                        TextInput::make('about_main_title'),
                        TextInput::make('about_subtitle'),
                        TextInput::make('about_title'),
                        Textarea::make('about_description'),
                        FileUpload::make('about_worker_image')
                            ->image()
                            ->directory('about'),
                        FileUpload::make('about_metallic_image')
                            ->image()
                            ->directory('about'),
                    ]),
                Section::make('Expertise Section')
                    ->schema([
                        TextInput::make('expertise_subtitle'),
                        TextInput::make('expertise_title'),
                        Textarea::make('expertise_description'),
                    ]),
            ])
            ->statePath('data');
    }

    protected function getFormActions(): array
    {
        return [
            Action::make('save')
                ->label(__('filament-panels::resources/pages/edit-record.form.actions.save.label'))
                ->submit('save'),
        ];
    }

    public function save(): void
    {
        $data = $this->form->getState();
        $settings = HomeSetting::first() ?? new HomeSetting();
        $settings->fill($data);
        $settings->save();

        Notification::make()
            ->title('Settings saved successfully')
            ->success()
            ->send();
    }
}
